	'----------------------------------------------------------------------------
	'	In order to interface with thinBasic Core engine, include thinCore.bi
	'----------------------------------------------------------------------------
	#include Once "thinCore.bi"

	'----------------------------------------------------------------------------
	'	Define here any global variable needed by this module
	'----------------------------------------------------------------------------

	'sub msgbox(s As String)
	'	MessageBox(null, WStr(s), WStr("Info"), MB_OK Or MB_ICONINFORMATION)
	'End sub


	sub Exec_FBGFX_Screen()
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------
		Dim ParensPresent 	As Long
		Dim lDeptPresent		As Long
		Dim lNPagesPresent	As Long
		Dim lMode 	As Long
		Dim lDept 	As Long
		Dim lNPages	As Long
		
		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		thinBasic_ParseLong(Lmode)

		If thinBasic_CheckComma_Optional = TB_TRUE Then
			lDeptPresent = TB_TRUE
			thinBasic_ParseLong(lDept)
			If thinBasic_CheckComma_Optional = TB_TRUE Then
				lNPagesPresent = TB_TRUE
				thinBasic_ParseLong(lNPages)
			End if
		End if
		
		If lDeptPresent = TB_TRUE Then
			If lNPAgesPresent = TB_TRUE Then
				Screen lMode, lDept, lNPages
			else
				Screen lMode, lDept
			End if
		else
			Screen lMode
		EndIf

		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End sub

	sub Exec_FBGFX_ScreenRes()
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------
		Dim ParensPresent 	As Long
		Dim lDeptPresent		As Long
		Dim lNPagesPresent	As Long
		Dim lWidth 	As Long
		Dim lHeight As Long
		Dim lDept 	As Long
		Dim lNPages	As Long

		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		thinBasic_ParseLong(lWidth)

		If thinBasic_CheckComma_Mandatory = TB_TRUE Then
			thinBasic_ParseLong(lHeight)

			If thinBasic_CheckComma_Optional = TB_TRUE Then
				lDeptPresent = TB_TRUE
				thinBasic_ParseLong(lDept)
				If thinBasic_CheckComma_Optional = TB_TRUE Then
					lNPagesPresent = TB_TRUE
					thinBasic_ParseLong(lNPages)
				End if
			End if
			
			If lDeptPresent = TB_TRUE Then
				If lNPAgesPresent = TB_TRUE Then
					ScreenRes lWidth, lHeight, lDept, lNPages
				else
					ScreenRes lWidth, lHeight, lDept
				End if
			else
				ScreenRes lWidth, lHeight
			EndIf
		End If
		
		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End sub

	sub Exec_FBGFX_ScreenSet()
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------
		Dim ParensPresent 	As Long
		Dim lVisiblePresent	As Long
		Dim lWorkPresent		As Long
		Dim lWork 				As Long
		Dim lVisible 			As Long
		
		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		lWorkPresent = thinBasic_ParseLong_Optional(lWork)

		If lWorkPresent = TB_TRUE then
			If thinBasic_CheckComma_Optional = TB_TRUE Then
				lVisiblePresent = TB_TRUE
				thinBasic_ParseLong(lVisible)
			End if
			
			If lVisiblePresent = TB_TRUE Then
				ScreenSet lWork, lVisible
			else
				ScreenSet lWork
			EndIf
		Else
			ScreenSet
		End if
		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End sub

	sub Exec_FBGFX_Locate()
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------

		Dim ParensPresent As Long
		Dim lX As Long, lY As Long
		
		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		thinBasic_ParseLong(lX)
		If thinBasic_CheckComma_Mandatory = TB_TRUE Then
			thinBasic_ParseLong(lY)
			Locate lX, lY
		EndIf

		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End sub
	
	sub Exec_FBGFX_Print()
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------

		Dim ParensPresent As Long

		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		Dim sBSTR As BSTR
		'Dim PBString As String

		thinBasic_ParseString(sBSTR)
		
		Print *cast( Zstring Ptr, sBSTR )

		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End sub

	sub Exec_FBGFX_WindowTitle()
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------

		Dim ParensPresent As Long

		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		Dim sBSTR As BSTR

		thinBasic_ParseString(sBSTR)
		
		WindowTitle *cast( Zstring Ptr, sBSTR )

		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End sub

	sub Exec_FBGFX_Sleep()
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------

		Dim ParensPresent As Long
		Dim lMSec As Long
		
		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		thinBasic_ParseLong(lMSec)
		If lMSec > 0 then
			Sleep lMSec
		Else
			Sleep
		End if

		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End sub

	sub Exec_FBGFX_Cls()
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------

		Dim ParensPresent As Long
		Dim lMode As Long
		
		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		thinBasic_ParseLong(lMode)
		If lMode > 0 then
			cls lMode
		Else
			cls
		End if

		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End sub

	function Exec_FBGFX_Color() As Long
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------

		Dim ParensPresent As Long
		Dim lFore As Long
		Dim lBack As Long
		
		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		thinBasic_ParseLong(lFore)
		If thinBasic_CheckComma_Mandatory = TB_TRUE Then
			thinBasic_ParseLong(lBack)

			Function = Color(lFore, lBack)
		EndIf

		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End function

	function Exec_FBGFX_RGB() As Long
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------

		Dim ParensPresent As Long
		Dim lR As Long
		Dim lG As Long
		Dim lB As Long
		
		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		thinBasic_ParseLong(lR)
		If thinBasic_CheckComma_Mandatory = TB_TRUE Then
			thinBasic_ParseLong(lG)
			If thinBasic_CheckComma_Mandatory = TB_TRUE Then
				thinBasic_ParseLong(lB)

				Function = RGB(lR, lG, lB)
			End if
		EndIf

		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End function

	function Exec_FBGFX_RGBA() As Long
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------

		Dim ParensPresent As Long
		Dim lR As Long
		Dim lG As Long
		Dim lB As Long
		Dim lA As Long
		
		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		thinBasic_ParseLong(lR)
		If thinBasic_CheckComma_Mandatory = TB_TRUE Then
			thinBasic_ParseLong(lG)
			If thinBasic_CheckComma_Mandatory = TB_TRUE Then
				thinBasic_ParseLong(lB)
				If thinBasic_CheckComma_Mandatory = TB_TRUE Then
					thinBasic_ParseLong(lA)
	
					Function = RGBA(lR, lG, lB, lA)
				End if
			End if
		EndIf

		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End function

	sub Exec_FBGFX_PSet()
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------

		Dim ParensPresent As Long
		Dim lX As Long
		Dim lY As Long
		Dim lColor As Long
		
		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		thinBasic_ParseLong(lX)
		If thinBasic_CheckComma_Mandatory = TB_TRUE Then
			thinBasic_ParseLong(lY)
			If thinBasic_CheckComma_Mandatory = TB_TRUE Then
				thinBasic_ParseLong(lColor)
				PSet (lX, lY), lColor
			EndIf
		EndIf

		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End sub

	sub Exec_FBGFX_Circle()
	'----------------------------------------------------------------------------
	'
	'----------------------------------------------------------------------------

		Dim ParensPresent As Long
		Dim lX As double
		Dim lY As double
		Dim lRadius As Double
		Dim lColorPresent As Long
		Dim lColor As double
		
		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		thinBasic_ParseDouble(lX)
		If thinBasic_CheckComma_Mandatory = TB_TRUE Then
			thinBasic_ParseDouble(lY)
			If thinBasic_CheckComma_Mandatory = TB_TRUE Then
				thinBasic_ParseDouble(lRadius)
				If thinBasic_CheckComma_Optional = TB_TRUE Then
					lColorPresent = TB_TRUE
					thinBasic_ParseDouble(lColor)
				End if
				If lCOlorPresent = TB_TRUE Then
					Circle (lX, lY), lRadius, lColor
				else
					Circle (lX, lY), lRadius
				EndIf
			EndIf
		EndIf

		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

	End sub

	Function Exec_FBGFX_InKey() As BSTR
	'----------------------------------------------------------------------------
	' This function returns a OLE string
	'----------------------------------------------------------------------------
		Dim ParensPresent As Long

		'---Check if open parens is present
		ParensPresent = thinBasic_CheckOpenParens_Optional

		Dim sBSTR 			As BSTR				'---OLE string will be used to return value to thinCore

		'---String will be used internally and than assigned to OLE string
		'---Here we use a dynamic string (that in reality is a pointer to a structure whose first
		'---4 bytes are a pointer to a buffer containing the real string
		'---In this case also a fized ZString would be ok
		Dim InKeyString 	As String
		
		'---Check inkey
		InKeyString = InKey
		'---If something was returned than we use it to allocate an OLE string
		If InKeyString <> "" then
			'---Allocate OLE string using specific APIs. In this case we use SysAllocStringByteLen
			'---in order to also pass an initial value string
			sBSTR = SysAllocStringByteLen( InKeyString, Len(InKeyString) )
		End If
		
		'---If initial parens was present that final one is mandatory
		If ParensPresent = TB_TRUE Then thinBasic_CheckCloseParens_Mandatory

		Function = sBSTR

	End Function


	FUNCTION LoadLocalSymbols Cdecl ALIAS "LoadLocalSymbols" (BYVAL sPath AS STRING) AS Long EXPORT 
	'----------------------------------------------------------------------------
	' This function is automatically called by thinCore whenever this DLL module is loaded.
	' This function MUST (repeat MUST) be present in every external DLL module you want to use
	' with thinBasic
	' Use this function to initialize every you need and for loading the
	' new symbol (read Keyword) you have created.
	'----------------------------------------------------------------------------
    	'msgbox(sPath) 
    	
		thinBasic_LoadSymbol "FBGFX_Screen"			, thinBasic_ReturnNone			, @Exec_FBGFX_Screen			, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_ScreenRes"		, thinBasic_ReturnNone			, @Exec_FBGFX_ScreenRes		, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_Locate"			, thinBasic_ReturnNone			, @Exec_FBGFX_Locate			, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_Print"			, thinBasic_ReturnNone			, @Exec_FBGFX_Print 			, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_WindowTitle"	, thinBasic_ReturnNone			, @Exec_FBGFX_WindowTitle	, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_Sleep"			, thinBasic_ReturnNone			, @Exec_FBGFX_Sleep			, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_PSet"			, thinBasic_ReturnNone			, @Exec_FBGFX_PSet			, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_Circle"			, thinBasic_ReturnNone			, @Exec_FBGFX_Circle			, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_Cls"				, thinBasic_ReturnNone			, @Exec_FBGFX_Cls				, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_Color"			, thinBasic_ReturnCodeLong		, @Exec_FBGFX_Color			, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_RGB"				, thinBasic_ReturnCodeLong		, @Exec_FBGFX_RGB				, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_RGBA"			, thinBasic_ReturnCodeLong		, @Exec_FBGFX_RGBA			, thinBasic_ForceOverWrite

		thinBasic_LoadSymbol "FBGFX_ScreenSet"		, thinBasic_ReturnNone			, @Exec_FBGFX_ScreenSet		, thinBasic_ForceOverWrite
		thinBasic_LoadSymbol "FBGFX_Inkey"			, thinBasic_ReturnString		, @Exec_FBGFX_InKey			, thinBasic_ForceOverWrite


 		FUNCTION = 0&
	END FUNCTION

	Function UnLoadLocalSymbols Cdecl ALIAS "UnLoadLocalSymbols" (BYVAL sPath AS STRING) AS Long EXPORT 
	'----------------------------------------------------------------------------
	'	This function is automatically called by thinCore whenever this DLL module is unloaded.
	'	This function CAN be present but in general it is not necessary.
	'	Only for modules developed with FreeBasic this function MUST be present and have
	'	a call to FreeBasic "End" statement. This is necessary in order to unload module from memory.
	'	Use this function to perform uninitialize process, if needed.
	'----------------------------------------------------------------------------

		'---Do whatever de-initialization here


		'---Important for FreeBasic modules: always call End here otherwise process will
		'---remain open in memory
			End
		'---
    
		FUNCTION = 0&

	END FUNCTION
